/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class IssueCmd {
    private static final String TRACE_MASKT = "XUTLCMDT";
    private static final String TRACE_MASKF = "XUTLCMDF";
    private static final String TRACE_MASKD = "XUTLCMDD";
    private String stdout;
    private String stderr;

    public IssueCmd() {
        Trace.trace(TRACE_MASKT, "<> IssueCmd()");
    }

    public int execute(String cmd) {
        Trace.trace(TRACE_MASKT, "-> IssueCmd.execute(String)");
        Trace.trace(TRACE_MASKD, "   IssueCmd.execute() - command is [" + cmd + "]");
        int count = 0;
        StringTokenizer st = new StringTokenizer(cmd);
        count = st.countTokens();
        String[] cmdarray = new String[count];
        st = new StringTokenizer(cmd);
        count = 0;
        while (st.hasMoreTokens()) {
            cmdarray[count++] = st.nextToken();
        }
        int rc = this.execute(cmdarray);
        Trace.trace(TRACE_MASKT, "<- IssueCmd.execute(String) - rc = " + rc);
        return rc;
    }

    public int execute(String[] cmd) {
        Trace.trace(TRACE_MASKT, "-> IssueCmd.execute(String[])");
        String args = "{";
        int i = 0;
        while (i < cmd.length) {
            args = args + "\"" + cmd[i] + "\", ";
            ++i;
        }
        int pos = args.lastIndexOf(44);
        args = args.substring(0, pos) + "}";
        Trace.trace(TRACE_MASKD, "   IssueCmd.execute() - input arguments are " + args);
        int rc = 0;
        try {
            Process pid = Runtime.getRuntime().exec(cmd);
            boolean done = false;
            while (!done) {
                try {
                    rc = pid.waitFor();
                    done = true;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            String line = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(pid.getInputStream()));
            do {
                if ((line = in.readLine()) == null) continue;
                this.stdout = this.stdout != null ? this.stdout + "\n" + line : line;
            } while (line != null);
            in = new BufferedReader(new InputStreamReader(pid.getErrorStream()));
            do {
                if ((line = in.readLine()) == null) continue;
                this.stderr = this.stderr != null ? this.stderr + "\n" + line : line;
            } while (line != null);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<- IssueCmd.execute(String[]) - rc = " + rc);
        return rc;
    }

    public String getOutput() {
        Trace.trace(TRACE_MASKT, "<> IssueCmd.getOutput() - [" + this.stdout + "]");
        return this.stdout;
    }

    public String getErrorOutput() {
        Trace.trace(TRACE_MASKT, "<> IssueCmd.getErrorOutput() - [" + this.stderr + "]");
        return this.stderr;
    }
}

